using System;
using System.IO;
using DynaPDF;

namespace collections
{
	class Collections
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
         try
         {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            pdf.SetDocInfo(DynaPDF.TDocumentInfo.diCreator, "C# test application");
            pdf.SetDocInfo(DynaPDF.TDocumentInfo.diKeywords, "PDF Collections; PDF Packages");
            pdf.SetDocInfo(DynaPDF.TDocumentInfo.diTitle, "PDF Collections");
            // The page of this file is shown when opening the file with an older version of Adobe's Acrobat.
            // Otherwise, the default document of the collection is opened. Click on "Cover sheet" to view the
            // contents of this page.
            pdf.SetImportFlags(DynaPDF.TImportFlags.ifImportAll | DynaPDF.TImportFlags.ifImportAsPage);
            if (pdf.OpenImportFile("../../../test_files/collection_en.pdf", DynaPDF.TPwdType.ptOpen, null) < 0)
            {
               Console.Write("Input file \"../../../test_files/collection_en.pdf\" not found!\n");
               Console.Read();
               return;
            }
            pdf.ImportPDFFile(1, 1.0, 1.0);
            pdf.CloseImportFile();

            pdf.CreateCollection(DynaPDF.TColView.civTile);
            int ef = pdf.AttachFile("../../../test_files/taxform.pdf", "A PDF file...", true);
            pdf.SetColDefFile(ef); // This file is opened when viewing the file Acrobat 8 or later
            pdf.AttachFile("../../../test_files/fulltest.emf", "An EMF file...", true);
            pdf.AttachFile("../../../test_files/sample.txt", "A text file...", true);
            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
         }
         Console.Read();
		}
	}
}
